(function($){

    $.fn.jbGalleryImageUpload = function( options ) {
        var settings = $.extend( {
                'uploadId': '',
                'url' : '',
                'maxNumberOfFiles' : 0,
                'previewMaxWidth' : 175,
                'previewMaxHeight' : 110,
                'columnNumber' : 4,
                'folder' : ''
            }, options);

    var fileupload = function() {
                $('.' + options.uploadId + '-galleryimage-fileupload').fileupload({
                    dropZone: $('.' + options.uploadId + ' .galleryimage-dropzone'),
                    url: options.url,
                    dataType: 'json',
                    autoUpload: true,
                    acceptFileTypes: /(\.|\/)(gif|jpe?g|png)$/i,
                    maxFileSize: 2000000,
                    maxNumberOfFiles: options.maxNumberOfFiles,
                    getNumberOfFiles: function () {
                        return $('.' + options.uploadId + ' .fl-files .fl-sort-images').length - 1;
                    },
                    disableImageResize: /Android(?!.*Chrome)|Opera/
                        .test(window.navigator.userAgent),
                    previewMaxWidth: options.previewMaxWidth,
                    previewMaxHeight: options.previewMaxHeight,
                    previewCrop: true,
                    formData: {id: options.folder}
                }).on('fileuploadadd', function (e, data) {
                    data.context = $('<li class="fl-sort-images uk-grid-margin uk-text-center"/>').appendTo($(this).parents('.fl-galleryimage').find('.fl-files'));
                    $.each(data.files, function (index, file) {
                        var node = $('<div/>')
                                .append($('<p class="uk-text-small uk-text-truncate uk-margin-small-top uk-margin-small-bottom"/>').html('<i class="fl-galleryimage-load-icon uk-icon-spinner uk-icon-spin"></i> ' + file.name));
                        node.appendTo(data.context);
                    });
                }).on('fileuploadprocessalways', function (e, data) {
                    var index = data.index,
                        file = data.files[index],
                        node = $(data.context.children()[index]);
                    if (file.preview) {
                        var canvas = data.files[0].preview;
                        var newImg = document.createElement("img");
                        newImg.src = canvas.toDataURL();
                        node.prepend(newImg);
                    }
                    if (file.error) {
                        $(this).parents('.fl-galleryimage').find('.fl-alert').removeClass('uk-hidden').append('<p class="uk-text-small uk-text-break">Файл <b>' + file.name + '</b> не загружен. Причина: ' + file.error + '.</p>');
                        node.closest('.fl-sort-images').remove();
                    }
                    if (index + 1 === data.files.length) {
                        data.context.find('button')
                            .text('Upload')
                            .prop('disabled', !!data.files.error);
                    }
                }).on('fileuploadprogressall', function (e, data) {
                    var progress = parseInt(data.loaded / data.total * 100, 10);

                    $(this).parents('.fl-galleryimage').find('.uk-progress').removeClass('hidden').find('.uk-progress-bar').css(
                        'width',
                        progress + '%'
                    );

                    if (progress != 100) {
                        $('#fl-submit-button').prop('disabled', true);
                    } else {
                        $('#fl-submit-button').prop('disabled', false);
                    }
                    
                }).on('fileuploaddone', function (e, data) {
                    if (!$('.fl-galleryimage-submission .fl-files').hasClass('uk-margin-top')) {
                        $('.fl-galleryimage-submission .fl-files').addClass('uk-margin-top');
                    };
                    var flgalleryimageSubmission = $('.' + options.uploadId + ' .fl-galleryimage-submission');
                    var flgalleryimage = $('.' + options.uploadId + ' .fl-galleryimage');
                    $.each(data.result.files, function (index, file) {
                        if (file.url) {

                            var count = flgalleryimage.find('.fl-files li').length;
                            
                            // Количество загруженных изображений
                            var imagesCount = parseInt(flgalleryimageSubmission.attr('fl-galleryimage-images'));

                            var link = $('<div class="fl-galleryimage-thumb uk-text-success uk-text-center">');
                            $(data.context.children()[index])
                                .wrap(link)
                                .find('.fl-galleryimage-load-icon').removeClass('uk-icon-spinner uk-icon-spin')
                                .addClass('uk-icon-check-circle-o');
                            $(data.context.children()[index]).append('<a data-name="' + file.name + '" class="fl-button-delete uk-text-small">Удалить</a><input class="hidden" name="elements[' + options.uploadId + '][0][images][' + imagesCount + '][file]" type="text" value="' + file.name + '">');

                            imagesCount++;
                            flgalleryimageSubmission.attr('fl-galleryimage-images', imagesCount);

                        } else if (file.error) {
                            $(this).parents('.fl-galleryimage').find('.fl-alert').removeClass('uk-hidden').append('<p class="uk-text-small uk-text-break">Файл <b>' + file.name + '</b> не загружен. Причина: ' + file.error + '.</p>');
                        }
                    });
                }).on('fileuploadfail', function (e, data) {
                    $.each(data.files, function (index) {
                        $(this).parents('.fl-galleryimage').find('.fl-alert').removeClass('uk-hidden').append('<p class="uk-text-small uk-text-break">Файл <b>' + file.name + '</b> не загружен.</p>');
                    });
                }).prop('disabled', !$.support.fileInput).parent().addClass($.support.fileInput ? undefined : 'disabled');
            }

            console.info(options);

            return this.each(fileupload);
    }

})(jQuery);